<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class PpvPurchase extends Model
{
    protected $fillable = [
        'user_id',
        'movie_id',
        'payment_id',
        'gst',
        'price',
        'offer_price',
        'hours',
        'expires_at',
        'status',
        'payment_type',
        'tv_series_id',
        'type'
    ];

    // Check if the purchase is expired
    public function isExpired()
    {
        return Carbon::now()->greaterThan($this->expires_at);
    }
    public function movie()
{
    return $this->belongsTo('App\Movie', 'movie_id', 'id')->withDefault();
}

public function tvseries()
{
    return $this->belongsTo('App\TvSeries', 'tv_series_id', 'id')->withDefault();
}

    
}
